## hpklinux.spec.in
##
##    AudioScience HPI driver
##    Copyright (C) 1997-2003  AudioScience Inc. <support@audioscience.com>
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of version 2 of the GNU General Public License as
##    published by the Free Software Foundation;
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 59 Temple Place, Suite 330,
##    Boston, MA  02111-1307  USA
##

Summary: A Linux HPI Driver for AudioScience Audio Adapters
Name: hpklinux
Version: 4.30.18-g23f629632
Release: 1
License: GPL
Packager: Fred Gleason <fredg@paravelsystems.com>
Group: System/Kernel
BuildRoot: /var/tmp/hpklinux-4.30.18-g23f629632
## required according to Mark Acosta for suse 9.2?
Conflicts: alsa-firmware
BuildRequires:   python-setuptools
Requires(pre,preun): /sbin/chkconfig, /sbin/depmod, /bin/rm, /bin/mv, /bin/mkdir
Requires(pre,preun): sh-utils

%package devel
Summary: Development files for AudioScience Audio Adapters
Group: Development/Libraries
Requires: hpklinux

%description
HPI driver for the AudioScience line of professional audio adapters.

%description devel
Development files for the AudioScience HPI driver.

%define _unpackaged_files_terminate_build 0
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

%post
/sbin/ldconfig

%preun

%prep

%build
make -C hpi-lib
make -C hpi-cli-apps
(cd asi-python && python setup.py build)

%install
make -C hpi-lib DESTDIR=%{buildroot} lib-install-dir=%{_libdir} include-install-dir=%{_includedir}/asihpi install
make -C hpi-cli-apps DESTDIR=%{buildroot} bin-install-dir=%{_bindir} install
(cd asi-python && python setup.py install --skip-build --root %{buildroot})

%clean

%files
%defattr(-,root,root)
%{_bindir}/*
%attr(755,root,root) %{_bindir}/hpi*
%{_libdir}/libhpi*.so*
%{python_sitelib}/*

%files devel
%{_includedir}/asihpi/hpi.h
%{_includedir}/asihpi/hpi_version.h
%{_libdir}/libhpi*.a

%changelog
* Thu Jan 18 2018 Delio Brignoli <dbrignoli@audioscience.com>
-- Remove driver. RPM for drivers are now built separately using DKMS
-- Use macros instead of autoconf placeholders and shell variables where possible
* Wed May 05 2010 Fred Gleason <fredg@paravelsystems.com>
-- Removed 'asihpi' init script.
-- Added a modprobe(8) call to initialize driver after installation.
-- Added a 'Conflicts:' rule for 'alsa-firmware'.
* Thu Apr 29 2010 Fred Gleason <fredg@paravelsystems.com>
-- Removed drvnotes_rc.txt.
* Fri May 23 2008 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- Change firmware names. Remove ASI4xxx firmware
* Wed Sep 26 2007 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- Add udev rule, remove asihpi script from bin
* Wed Jun 06 2007 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- Restructure directories. Remove firmware.agent install
* Fri Aug 11 2006 Fred Gleason <fredg@salemradiolabs.com>
-- Added conditional library path to support x86_64 architecture.
* Tue May 16 2006 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- Remove DSP support for 4[456]00, 8800, add 6600
* Fri Mar 17 2006 Fred Gleason <fredg@salemradiolabs.com>
-- Fixed the library versioning to automatically track changes.
* Fri Feb 10 2006 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- Alter dsp bin install to use DSPBINPATH from Autoconf
* Wed Feb 08 2006 Fred Gleason <fredg@salemradiolabs.com>
-- Altered install paths to use $prefix value from Autoconf.
* Thu May 19 2005 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- add dsp6205, remove dsp8705
* Thu Jan 27 2005 Eliot Blennerhassett <eblennnerhassett@audioscience.com>
-- fixed install paths for test software
* Mon Jan 17 2005 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- added asihpitune
* Wed Aug 18 2004 Fred Gleason <fredg@salemradiolabs.com>
-- Corrected for proper module path/name on both 2.4.x and 2.6.x kernels.
* Thu Aug 05 2004 Fred Gleason <fredg@salemradiolabs.com>
-- Added 'depmod -a' to %post.
-- Added a rule to install '/etc/hotplug/firmware.agent' if needed.
* Tue Aug 03 2004 Fred Gleason <fredg@salemradiolabs.com>
-- Modified for new firmware layout.
-- Modified to support dynamic library binaries.
-- Added a 'devel' subpackage.
* Thu Mar 04 2004 EB
-- Fixed date typo below. Fix path to INSTALL.hpi
* Wed Feb 04 2004 Eliot Blennerhassett <eblennerhassett@audioscience.com>
-- Removed asihpiload and asihpiunload, added thpilinux,hpiassert
* Tue Feb 03 2004 Fred Gleason <fredg@salemradiolabs.com>
-- Changed autosubstitution of kernel version to use AC_SUBST macro
rather than sed(1).
* Mon Dec 01 2003 Fred Gleason <fredg@salemradiolabs.com>
-- Added spec file to the base HPK source tree as part of the
project to autoconfiscate the driver.
* Mon Dec 02 2002 Fred Gleason <fredg@wava.com>
- Updated for SuSE 8.0/SMP and HPK v2.74.
* Wed Oct 30 2002 Fred Gleason <fredg@wava.com>
- Updated for SuSE 8.1 and HPK v2.73.
* Fri Sep 27 2002 Fred Gleason <fredg@wava.com>
- Initial package creation.
