#!/usr/bin/env python
"""Convert numeric HPI log format to symbolic

E.g from
HPI_MSG0,0,0,1288,147
HPI_RES0,103,0
to
HPI request adap=0 MIXER_GET_CONTROL_BY_INDEX objidx=0 147
HPI response ERROR INVALID_OBJ_INDEX
"""

from hpi_dicts import *

import sys

try:
    f = open(sys.argv[1])
except:
    f = sys.stdin

for l in f.readlines():
    l = l.strip()
    pm = l.find('HPI_MSG')
    pr = l.find('HPI_RES')
    if pm >= 0:
        fields = l.split(',')
        prefix = l[:pm]
        version = fields[0][-1]

        f3 = int(fields[3])

        try:
            f4 = int(fields[4])
        except:
            f4 = 0

        if f3 & 0xFF00 == 0x700 and version == '0':
            print '%sHPI request adap=%d %s objidx=%d %s' % (
                prefix,
                int(fields[1]), hpi_functions.get(f3, 'func?'), int(fields[2]),
                hpi_control_attributes.get(f4, 'attr 0x%x?' % f4))
        elif version != '0':
            print '%sHPI request v%s adap=%d %s objidx=%d %d' % (
                prefix, version,
                int(fields[1]), hpi_functions.get(f3, 'func?'), int(fields[2]), f4)
        else:
            print '%sHPI request adap=%d %s objidx=%d %d' % (
                prefix,
                int(fields[1]), hpi_functions.get(f3, 'func?'), int(fields[2]), f4)
    elif pr >= 0:
        fields = l.split(',')
        prefix = l[:pr]

        try:
            err = int(fields[1])
        except:
            err = 0
        try:
            if fields[2] == '0':
                specerr = ''
            else:
		specerr = '(%s)' % fields[2]
	except:
		specerr = ''
        if err:
            print '%sHPI response ERROR %s %s' % (prefix, hpi_errors.get(err, 'unknown %d' % err), specerr)
        else:
            print '%sHPI response OK' % prefix
    elif True:
        print l
