/******************************************************************************
 HPI Extended Message Handler Functions

    Copyright (C) 1997-2017  AudioScience Inc. <support@audioscience.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of version 2 of the GNU General Public License as
    published by the Free Software Foundation;

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/

#ifndef _HPIMSGX_H_
#define _HPIMSGX_H_

#include "hpi_internal.h"

#ifdef __cplusplus
/* *INDENT-OFF* */
extern "C" {
/* *INDENT-ON* */
#endif

#define HPIMSGX_ALLADAPTERS	(0xFFFF)

#ifndef HPI_MESSAGE_LOWER_LAYER
void HPI_MessageEx(
		struct hpi_message *phm,
		struct hpi_response *phr,
		struct hpi_adapter_obj *pao,
		void *hOwner
);

#define HPI_MESSAGE_LOWER_LAYER HPI_MessageEx
#endif

uint16_t HPIMSGX_AdapterPrepare(struct hpi_adapter_obj *pao);
uint16_t HPIMSGX_AdapterWake(struct hpi_adapter_obj *pao);

struct hpi_adapter_obj *HpiGetAdapterFromRef(void *ref);
void *HpiGetOwnerFromRef(void *ref);

#ifdef __cplusplus
/* *INDENT-OFF* */
}
/* *INDENT-ON* */
#endif

#endif				/* _HPIMSGX_H_ */
