/*
 * hpiudp_cache.c
 *
 * Control caching module.
 *

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

 *
 */
#ifndef _HPIUDP_CACHE_H_
#define _HPIUDP_CACHE_H_

#ifdef HPIUDP_USE_CACHE

struct hpi_adapter;

struct hpiudp_cache_update_time {
	uint32_t all_info;
	uint32_t value;
	uint32_t limits;
};

struct hpiudp_cache_context {
	//unsigned int nControls;
	unsigned int timeStamp_ms;
	struct hpi_control_defn *controlDef;
	//size_t cache_size;
	uint8_t *controlCacheData;
	struct hpi_control_cache *controlCache;
	/** pointer to timestamp information. */
	struct hpiudp_cache_update_time *pTimeStamp;
};

typedef int (*ptr_fn_messsage)(struct hpi_adapter *pA,
	struct hpi_message *phm,
	struct hpi_response *phr,
	const unsigned int nThisTimeout_ms);

int hpudp_cache_init(
	struct hpi_adapter *pA,
	uint16_t adapter_index,
	struct hpiudp_cache_context **cache,
	ptr_fn_messsage msg_fn,
	struct hpi_response *phr);

void hpiudp_cache_free(
	struct hpiudp_cache_context **cache);

int hpiudp_cache_message(
	struct hpi_adapter *pA,
	uint16_t adapter_index,
	uint32_t *mixer_is_open,
	struct hpiudp_cache_context **cache,
	ptr_fn_messsage msg_fn,
	struct hpi_message *phm,
	struct hpi_response *phr,
	int *nHandled,
	int *nCachingError);

int hpiudp_cache_check_for_control(struct hpi_adapter *pA,
	uint16_t adapter_index,
	struct hpiudp_cache_context *cache,
	struct hpi_message *phm,
	struct hpi_response *phr,
	int *nHandled,
	int *nCachingError);

int hpiudp_cache_update(
	struct hpi_adapter *pA,
	uint16_t adapter_index,
	struct hpiudp_cache_context *cache,
	ptr_fn_messsage msg_fn,
	struct hpi_response *phr,
	const unsigned int nTimeOut_ms);

int hpiudp_cache_update_now(struct hpi_adapter *pA,
		uint16_t adapter_index,
		struct hpiudp_cache_context *cache_context,
		ptr_fn_messsage msg_fn,
		struct hpi_response *phr,
		const unsigned int nTimeOut_ms,
		unsigned int timestamp);
#endif
#endif
