/******************************************************************************
 Hardware Programming Interface (HPI) Utility functions

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

*******************************************************************************/
/* Initialise response headers, or msg/response pairs.
Note that it is valid to just init a response e.g. when a lower level is
preparing a response to a message.
However, when sending a message, a matching response buffer must always be
prepared.
*/

#ifndef _HPIMSGINIT_H_
#define _HPIMSGINIT_H_

#ifdef __cplusplus
extern "C" {
#endif

void HPI_InitResponse(
	struct hpi_response *phr,
	uint16_t wObject,
	uint16_t wFunction,
	uint16_t wError
);

HPI_API_VOID (void) HPI_InitMessageResponse(
	struct hpi_message *phm,
	struct hpi_response *phr,
	uint16_t wObject,
	uint16_t wFunction);

void HPI_InitResponseV1(
	struct hpi_response_header *phr,
	uint16_t wSize,
	uint16_t wObject,
	uint16_t wFunction);

void HPI_InitMessageResponseV1(
	struct hpi_message_header *phm,
	uint16_t wMsgSize,
	struct hpi_response_header *phr,
	uint16_t wResSize,
	uint16_t wObject,
	uint16_t wFunction);

#ifdef __cplusplus
}
#endif
#endif  /* _HPIMSGINIT_H_ */
