/*

Copyright (C) 1997-2017 AudioScience, Inc. All rights reserved.

This software is provided 'as-is', without any express or implied warranty.
In no event will AudioScience Inc. be held liable for any damages arising
from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This copyright notice and list of conditions may not be altered or removed
   from any source distribution.

AudioScience, Inc. <support@audioscience.com>

( This license is GPL compatible see http://www.gnu.org/licenses/license-list.html#GPLCompatibleLicenses )

*/
#ifndef _FWUPDATE_H_
#define  _FWUPDATE_H_

#include "hpi_internal.h"

#ifdef __cplusplus
/* *INDENT-OFF* */
extern "C" {
/* *INDENT-ON* */
#endif

/*
if(percent>0)
	use printf( state, percent)
else
	use printf( state )
*/

enum eHpiFirmwareId {
	HPI_FW_UPDATE = 1,
	HPI_FW_FACTORY = 2,
	HPI_FW_BOOTLOADER = 3
};

enum eHpiFirmwareStatus {
	HPI_FW_PROGSTATUS_ERASING = 1,
	HPI_FW_PROGSTATUS_PROGRAMMING = 2,
	HPI_FW_PROGSTATUS_DONE = 3,
	HPI_FW_PROGSTATUS_FAILURE = 4,
};

typedef void HPI_CALLBACK progress_callback(char *state, uint32_t percent);
typedef void HPI_CALLBACK progress_callbackex(enum eHpiFirmwareStatus status, uint32_t percent, void *user_arg);

HPI_API (hpi_err_t) HPI_FileFirmwareGetInfo(const char *fwpath,
	uint16_t nBootLoadFamily,
	uint16_t nBootLoadFamilyMask,
	unsigned int *adapter,
	unsigned int *version,
	unsigned int *checksum,
	unsigned int *length);

HPI_API (hpi_err_t) HPI_AdapterFirmwareDownload(
	uint16_t wAdapterIndex,
	enum eHpiFirmwareId ft,
	const char *fwpath,
	uint16_t nBootLoadFamily,
	uint16_t nBootLoadFamilyMask,
	progress_callback * pc);

HPI_API (hpi_err_t) HPI_AdapterFirmwareDownloadEx(
	uint16_t wAdapterIndex,
	enum eHpiFirmwareId ft,
	const char *fwpath,
	uint16_t nBootLoadFamily,
	uint16_t nBootLoadFamilyMask,
	progress_callback * pc,
	progress_callbackex * pcex,
	void *user_arg);


HPI_API (hpi_err_t) HPI_AdapterFirmwareGetInfo(
	uint16_t adapterIndex,
	enum eHpiFirmwareId fwid,
	unsigned int *version,
	unsigned int *checksum,
	unsigned int *length);

HPI_API (hpi_err_t) HPI_AdapterFirmwareGetInfo2(
	uint16_t adapterIndex,
	enum eHpiFirmwareId fwid,
	unsigned int *version,
	unsigned int *checksum,
	unsigned int *length,
	unsigned int *family,
	unsigned int *max_length
	);

#ifdef __cplusplus
/* *INDENT-OFF* */
}
/* *INDENT-ON* */
#endif
#endif
